/*
 * \file   main.c
 *
 * \brief  Sample application for G2553 using MSPBoot
 *      This example places application in the appropiate area
 *      of memory (check linker file) and shows how to use redirected 
 *      interrupts 
*/
/* --COPYRIGHT--,BSD
 * Copyright (c) 2017, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/
#include <msp430x471x7.h>
#include <stdint.h>
#include "TI_MSPBoot_Mgr_Vectors.h"
#include "intrinsics.h"
#include "Emeter.h"
#include "LC_glass.h"
/******************************************************************************
 *
 * @brief   Main function
 *  This example application performs the following functions:
 *  - Toggle LED1 (P1.0) at startup (to indicate App1 execution)
 *  - Toggles LED1 using a timer periodic interrupt (demonstrates vector redirection)
 *  - Forces Boot mode when button S2 (P1.3) is pressed (demonstrates vector
 *      redirection and Boot Mode call
 *
 * @return  none
 *****************************************************************************/
unsigned char dummy_var,tx_byte=0;
unsigned int count_ms=0;
int16_t V_Sample[3];
int16_t I_Sample[4];
int16_t I_Neutral_Sample;
unsigned char slv_buf[5]={0x10,0x20,0x30,0x40,0x50};
extern unsigned char array_lc[385];
//void SD16_Init(void);
extern void LC_seg_on(void);
extern void LC_display(void);

int32_t div48(register int16_t x[3], register int16_t y);
void delay(unsigned long);

void cal_long_value(void);
void cal_pftype(void);
void First_time_boot(void);
void pow_on_disp_msg(void);
//void resetallres(void);
#ifdef FFT
    void Harmonics_measurement(void);
#endif
union Hrs ON,LOAD,IDLE,LOAD_IMP,LOAD_EXP;
union Hrs2 hours;
union para pm;
union fenr f_en;
union Fpara fp;

union Mbus Mb;
union Mbus_long Mb_l;

union fenr1 f_en1;
union Fpara1 fp1;

union fenr2 f_en2;
union Fpara2 fp2;

union fenr3 f_en3;
union Fpara3 fp3;

union Fpara_peak fp_peak;
union fenr_peak f_en_peak;
// Definitions of Variables used in this file
// PHASE Phase[4];
//uint32_t Total_Power_Active,Total_Power_Reactive,Total_Power_Apparent;
//int32_t Total_Energy,Total_REnergy,Temp_Total_Energy;
//uint32_t Average_PF=0;
unsigned int Frequency_meas[3];
extern signed long mains_period[3];
unsigned int k;

double uniterngy_act_import[4];         //16
double uniterngy_act_export[4];         //16
double uniterngy_React_lag[4];          //16
double uniterngy_React_lead[4];         //16
double uniterngy_apparent[4];           //16

float temp_scale1[3],temp_scale;
float temp_pf[3],angle[3],ang_diff[3];
int pcb_bit[3];
float phase_X1=0,phase_X2=0,phase_X3=0,phase_Y1=0,phase_Y2=0,phase_Y3=0;
float sum_x=0,sum_y=0,mul_x=0,mul_y=0;
float day_act_imp;
float day_act_exp;
float day_React_lag;
float day_React_lead;
float day_apparent;

float cntr_act_imp;
float cntr_act_exp;
float cntr_React_lag;
float cntr_React_lead;
float cntr_apparent;

unsigned char max_min_cal_wait,pow_on_display=4;
int32_t V_Calc_Sum_R,V_Calc_Sum_B,V_Calc_Sum_Y,I_Calc_Sum_R,I_Calc_Sum_B,I_Calc_Sum_Y, VI_Calc_Sum_R, VI_Calc_Sum_B, VI_Calc_Sum_Y,I_Raw[3];
unsigned char Self_Calibrate=YES;
unsigned char Emeter_State=EMETER_ACTIVE,gain_Calibrate=0,unitenergy[4]={0,0,0,0};
unsigned char Accumulate_Samples=YES;
unsigned char Data_ReadOut_State=WAITING_READOUT_COMMAND;
uint16_t Data_Readout_Pointer=0;
unsigned int whi_ovcnt=0,whe_ovcnt=0,vari_ovcnt=0,vare_ovcnt=0,va_ovcnt=0;
unsigned char mbus_Frame_Recieved=0,rx_byte=0,byte_counter=0,f_err_crc=0,init_delay=10;
//unsigned char slv_buf[300]={0};
unsigned char slave_id_changed=0,old_id=0;
float I_Gain_4_devide[3];
float V_Gain_4_devide[3],Vpp_Gain_4_devide[3],V_Gain_2_devide[3],Vpp_Gain_2_devide[3];
float VI_Gain_4_devide[3];
//unsigned int cfg_val[36],PWM_cal[8],count_diff[4],range[4];
//unsigned long Enr_val[10];
float avg_active[3][3]={0,0,0,0,0,0,0,0,0},avg_Reactive[3][3]={0,0,0,0,0,0,0,0,0},avg_power=0,avg_Repower=0;
//unsigned int temp1_baud=0,total_freq_range;
//long Ao_count=8388,PWM_count[4]={8388,8388,8388,8388};
int I_low=300;
//unsigned int ao_range;
float act_impenergy[4]={0,0,0,0},act_expenergy[4]={0,0,0,0},React_lagenergy[4]={0,0,0,0},React_leadenergy[4]={0,0,0,0},Apparent_energy[4]={0,0,0,0};
//float act_impenergy_1[4]={0,0,0,0},act_expenergy_1[4]={0,0,0,0},React_lagenergy_1[4]={0,0,0,0},React_leadenergy_1[4]={0,0,0,0},Apparent_energy_1[4]={0,0,0,0};
float DB=0,DB_1=0;
float EnergyPerPulse1=0;//,EnergyPerPulse2=0;
//unsigned long EnergyPerPulse;//,EnergyPerPulse2=0;
//unsigned long frq_Ao_multiplier[4],volt_Ao_multiplier[4],current_Ao_multiplier[4];
//long PF_Ao_multiplier[4],Actpower_Ao_multiplier[4],Reactpower_Ao_multiplier[4],Aprtpower_Ao_multiplier[4];
struct power_factor PF;
#ifdef MEASURE_V_PHASE_2_PHASE
int32_t V_RY_Calc_Sum,V_YB_Calc_Sum,V_BR_Calc_Sum;
//uint32_t V_RY_rms,V_YB_rms,V_BR_rms,V_RYB_rms;
#endif

#ifdef NEUTRAL_MEAS
int32_t I_Calc_Sum_Neut,I_RBY_Calc_Sum;
#endif

#ifdef REACT_POWER_BY_HILBERT_TXFM
int32_t V90I_Calc_Sum_R,V90I_Calc_Sum_Y,V90I_Calc_Sum_B;
extern const unsigned int Hilbert_Correction_Constant[];
#endif

#ifdef FUNDAMENTAL_POWER_SUPPORT
int32_t VI_Fund_Calc_Sum_R, VI_Fund_Calc_Sum_Y, VI_Fund_Calc_Sum_B;
int32_t VV_Fund_Calc_Sum_R, VV_Fund_Calc_Sum_Y, VV_Fund_Calc_Sum_B;
#endif

#ifdef RADIOCRAFTS_DEMO

unsigned char Radiocrafts_Command=NO;
unsigned char TX_Data[20];
unsigned char rx_seconds=0;

#endif

#ifdef I_NEUTRAL_MEASURE
int32_t I_Calc_Neutral;
uint32_t I_Neutral_rms;
unsigned int I_Neutral_Scale=0x124b;
#endif


#ifdef PHASE_IMBALANCE_DETECT
int32_t I_Calc_Residue;
uint32_t I_Residue_rms;
#endif
unsigned int P_intr = 0;
//unsigned int st_eng=0;
#ifdef RTC_CALENDAR
unsigned char p_off_year, p_off_month, p_off_date, p_off_hour, p_off_min, p_off_sec;
unsigned char p_on_year, p_on_month, p_on_date, p_on_hour, p_on_min, p_on_sec;

//unsigned char a=0;
unsigned char prev_Date;
#endif

unsigned char rx_byte_timeout;
unsigned char quadrant=0;
unsigned char eng_cnt=0;
//uint32_t Chander_Power[200];
//unsigned int Chander_Count=0;

unsigned char Phase_Reversal_Detected=NO;

unsigned char Check_change[3][5] = {3,3,3,3,3,3,3,3,3,3,3,3,3,3,3};
float Enery_resolution[3] = {0.001,0.001,0.001};
float Energy_pls[3] = {921600.0, 921600.0, 921600.0};
float per_volt[3],max_volt;
float per_curr[3],max_curr;
float phase_ang[3];
signed char Sign[4];
signed char CapInd[4];
unsigned char init_disp,watchdog_byte=0,ry_cnt=0,rb_cnt=0,br_cnt=0;
float BR_freq;
float RY_phase_angle_cos=0,RY_phase_angle_sin=0,phase_ang_RY=0,phase_ang_RY_1=0,phase_ang_RY_2=0;
float RB_phase_angle_cos=0,RB_phase_angle_sin=0,phase_ang_RB=0,phase_ang_RB_1=0,phase_ang_RB_2=0;
float BR_phase_angle_cos=0,BR_phase_angle_sin=0,phase_ang_BR=0,phase_ang_BR_1=0,phase_ang_BR_2=0;
float I_phase_ang_RY_2=0,I_phase_ang_RB_2=0;

float In_current,Iy_current_angle;
unsigned char a=0,c=0;
unsigned int temp_RY,temp_RB,temp_BR,V_temp_RY;
float RY_array_avg,RB_array_avg,BR_array_avg;
unsigned char In_cnt,Iy_cnt;
#ifdef FFT
    float fft[6][9]={
                    0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
                    0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
                    0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
                    0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
                    0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
                    0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
                    };
    unsigned char phase_fft = 6;
    unsigned char max_sample_cnt = 41;
    int *ptr_phase;
    extern signed int Sample_array[50];
    extern signed int V_Act[3];
    extern signed int I_Act[4];

#endif
unsigned char dummy1;




int main( void )
{
  // Stop watchdog timer to prevent time out reset
  WDTCTL = WDTPW + WDTHOLD;


      P10DIR = 0x0F;    //0 b 0000 1111;
      P10OUT = 0x00;  //0 b 0000 0000;
      P10SEL = 0x00;  //0 b 0000 0000;

      P3DIR = 0xFB; //0 b 1111 1011;
      P3OUT = 0x09;   //0 b 0000 1001;
      P3SEL = 0x0E;   //0 b 0000 1110;

      // Toggle LED1 in P9.5
    P9DIR |= BIT2;
    P9OUT &= ~BIT2;
    P9DIR |= BIT5;
    P9OUT |= BIT5;
    //__delay_cycles(500000);
    P9OUT &= ~BIT5;
    //__delay_cycles(500000);
    P9OUT |= BIT5;        //OFF
   // __delay_cycles(500000);
    P9OUT &= ~BIT5;       //ON

    // Start P1.3 (S2 button) as interrupt with pull-up
    P1OUT |= BIT3;
    P1REN |= BIT3;
    P1IES &= BIT3;
    P1IE |= BIT3;

    // Start Timer interrupt
    CCTL0 = CCIE;                             // CCR0 interrupt enabled
    CCR0 = 5000-1;
    TACTL = TASSEL_1 + MC_1;                  // ACLK, upmode*/

	 LC_seg_on();
	 array_lc[masibus]=masibus_ON;
	 b.run_mode = 1;
	 run_para = 11;
	 __enable_interrupt();
    //__bis_SR_register(LPM3_bits + GIE);

     while(1)
     {

         if(b.run_mode)
            Run_Mode();
         else if(b.password_check)
             Password_Mode();
//         else if(b.program_mode)     // If this four line are commented then controller become reset
//             Program_Mode();
//         else if(b.reset_reg_mode)
//             Rst_reg_mode();


     }


  //return 0;
}

/******************************************************************************
 *
 * @brief   Timer A Interrupt service routine
 *  This routine simply toggles an LED but it shows how to declare interrupts
 *   in Application space
 *   Note that this function prototype should be accessible by 
 *   TI_MSPBoot_Mgr_Vectors.c and it should be declared in ProxyVectorTable
 *
 * @return  none
 *****************************************************************************/
__interrupt void Timer_A (void)
{
  P9OUT ^= 0x20;                            // Toggle P9.5
  CCTL0 &= ~CCIFG;

}


/******************************************************************************
 *
 * @brief   Port 1 Interrupt service routine
 *  Forces Boot mode when button S2 (P1.3) is pressed
 *   Note that this function prototype should be accessible by TI_MSPBoot_Mgr_Vectors.c
 *   and it should be declared in ProxyVectorTable
 *
 * @return  none
 *****************************************************************************/
__interrupt void P1_Isr(void)
{
    P1IFG = 0;
    TI_MSPBoot_JumpToBoot();
}


/******************************************************************************
 *
 * @brief   Dummy Interrupt service routine
 *  This ISR will be executed if an undeclared interrupt is called
 *
 * @return  none
 *****************************************************************************/
#pragma vector = unused_interrupts
__interrupt void Dummy_Isr(void)
{
    while(1)
        ;
}

